#ifndef SCENA_H
#define SCENA_H

#include <windows.h>
#include <gl/gl.h>
#include <vector>
#include <string>
#include <stdexcept>
#include <sstream>


class WyjatekOBJ : public std::exception
{
public:
	WyjatekOBJ(const std::string& wiadomosc, const std::string& nazwaPliku, unsigned int numerLinii)
	{
		std::ostringstream oss;
		oss << "Bd odczytu pliku " << nazwaPliku << " (" << numerLinii << "): " << wiadomosc;
		throw exception(oss.str().c_str());
	}
};


struct SWierzcholek2
{
	GLfloat x;
	GLfloat y;
};


struct SWierzcholek3
{
	GLfloat x;
	GLfloat y;
	GLfloat z;
};


struct SWierzcholek4
{
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat w;
};


struct STrojkat
{
	GLuint w1;
	GLuint w2;
	GLuint w3;
	GLuint t1;
	GLuint t2;
	GLuint t3;
	GLuint n1;
	GLuint n2;
	GLuint n3;
};


//Typ uywanych trojktw 		
enum ETypTrojkata
{
	TYPTROJKATA_NIEPOPRAWNY, //bdny
	TYPTROJKATA_W,   //Wierzcholek
	TYPTROJKATA_WT,  //Wierzchoek-wsp.Tekstury
	TYPTROJKATA_WN,  //Wierzchoek-Normalna
	TYPTROJKATA_WTN  //Wierzchoek-wsp.Tekstury-Normalna
};


class CModel
{
public:
	CModel();

	const std::string& Nazwa(void) const{return this->nazwa;}
	ETypTrojkata TypTrojkatow(void){return this->typTrojkatow;}
	const std::vector<STrojkat>& Trojkaty(void) const{return this->trojkaty;}
protected:
	ETypTrojkata typTrojkatow;
	std::string nazwa;
	std::vector<STrojkat> trojkaty;

	friend class CScena;
};

typedef CModel* CModelWsk;


class CScena{
public:
	~CScena();
	
	void Wczytaj(const std::string& nazwaPliku);
	unsigned int LiczbaModeli(void) const{return this->modele.size();}
	const std::vector<CModelWsk>& Modele(void) const {return this->modele;}
	const std::vector<SWierzcholek4>& Wierzcholki(void) const {return this->wierzcholki;}
	const std::vector<SWierzcholek3>& Normalne(void) const {return this->normalne;}
	const std::vector<SWierzcholek2>& WspolrzedneTekstur(void) const {return this->wspolrzedneTekstur;}
protected:
	std::vector<SWierzcholek4> wierzcholki;
	std::vector<SWierzcholek3> normalne;
	std::vector<SWierzcholek2> wspolrzedneTekstur;
	std::vector<CModelWsk> modele;

	void Wyczysc(void);
	ETypTrojkata OdczytajIndeksy(const std::string& str, GLuint& vertex, GLuint& texture, GLuint& normal) const;
	void Podziel(const std::string& str, std::vector<std::string>& fragmenty,  const char* c = " \t") const;
};

typedef CScena* CScenaWsk;


#endif